<?php

namespace Import\ApiBundle\Services\Import;


class ImportSessionIndexGPW extends ImportMainService
{
    protected $urlZip = 'http://bossa.pl/pub/metastock/mstock/sesjaall/few_last.zip';

    protected $columns = array("Name","Date","Open","High","Low","Close","Volume","Oi");

    protected $type = 'IndexGPW';

    public function import()
    {
        $data = $this->getCSVFromZip($this->urlZip,$this->type,$this->columns);

        $i = 0;
        foreach($data as $row)
        {
            $this->save($row);
            $i++;
        }

        $this->getDoctrine()->getEntityManager()->flush();
        $this->viewErrors();

        return array('count' => $i);
    }

    protected function save($data)
    {
        $data['IndexGPW'] = $this->getIndexGPWBySymbol($data['Name']);
        $SessionIndexGPW = $this->getDoctrine()->getRepository('ImportApiBundle:SessionIndexGPW')->add($data);

        return $SessionIndexGPW;
    }
}